<?php
if (!class_exists('DBSEO')) { die('No direct loading allowed.'); }

// #############################################################################
// Blog class

/**
* Handles various functionality for Image
*/
class DBSEO_Script_Group
{
	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return string
	 */
	public static function replaceUrls(&$_preventProcessing, &$_seoParameters, &$urlPrefix, &$url, &$urlSuffix, &$inTag, &$_urlScript, &$_urlPlace, &$_urlParameters, &$_removeAllParameters, &$_cmsUrlAppend, &$nofollow, &$follow)
	{
		$newUrl = $_urlFormat = '';
		
		if (!DBSEO::$config['dbtech_dbseo_rewrite_socialgroup'])
		{
			// We're not rewriting this
			return false;
		}

		if ($_seoParameters['pp'] == DBSEO::$config['vm_perpage'])
		{
			// We don't need perpage if it's default
			unset($_seoParameters['pp']);
		}

		if (isset($_seoParameters['page']) AND $_seoParameters['page'] < 2)
		{
			// We don't want to display page if it's 1
			unset($_seoParameters['page']);
		}

		$noClear = false;
		if ($_seoParameters['gmid'] AND !isset($_seoParameters['do']))
		{
			$_seoParameters['page'] = DBSEO::getGroupPage($_seoParameters['groupid'], $_seoParameters['gmid']);
			$_urlPlace = 'gmessage' . $_seoParameters['gmid'];
		}
		else if ($_seoParameters['gmid'] AND $_seoParameters['do'] == 'discuss')
		{
			// Set the page
			$_seoParameters['page'] = DBSEO::getGroupMessagePage($_seoParameters['discussionid'], $_seoParameters['gmid']);

			if ($newUrl = DBSEO::createUrl('SocialGroup_SocialGroupDiscussion' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters))
			{
				$_urlPlace = 'gmessage' . $_seoParameters['gmid'];

				// Get rid of some 
				unset($_seoParameters['gmid'], $_seoParameters['do'], $_seoParameters['page']);
			}
		}
		else if (
			$_seoParameters['do'] == 'grouplist' AND (
				$_seoParameters['sort'] == 'lastpost' OR !$_seoParameters['sort']
			) AND (
				!$_seoParameters['order'] OR $_seoParameters['order'] == 'desc'
			)
		)
		{
			// Get rid of some params we don't need
			unset($_seoParameters['sort'], $_seoParameters['order']);
		}

		if (!$newUrl)
		{
			if ($_seoParameters['do'] == 'grouplist' AND !$_seoParameters['cat'])
			{
				if ($newUrl = DBSEO::createUrl('SocialGroup_SocialGroupList' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters))
				{
					// Get rid of a few params
					unset($_seoParameters['page'], $_seoParameters['do']);
					
					// Don't get rid of everything
					$noClear = true;
				}
			}
			else if ($_seoParameters['do'] == 'discuss' AND !$_seoParameters['gmid'])
			{
				if ($newUrl = DBSEO::createUrl('SocialGroup_SocialGroupDiscussion' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters))
				{
					// Get rid of a few params
					unset($_seoParameters['page'], $_seoParameters['do'], $_seoParameters['group'], $_seoParameters['discussionid']);
					
					// Don't get rid of everything
					$noClear = true;
				}
			}
			else if ($_seoParameters['do'] == 'categorylist')
			{
				if ($newUrl = DBSEO::createUrl('SocialGroup_SocialGroupCategoryList' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters))
				{
					// Get rid of a few params
					unset($_seoParameters['page'], $_seoParameters['do']);
					
					// Don't get rid of everything
					$noClear = true;
				}
			}
			else if ($_seoParameters['cat'] AND (count($_seoParameters) == 1 OR $_seoParameters['page'] OR $_seoParameters['do'] == 'grouplist'))
			{
				if ($newUrl = DBSEO::createUrl('SocialGroup_SocialGroupCategory' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters))
				{
					// Get rid of a few params
					unset($_seoParameters['cat'], $_seoParameters['do'], $_seoParameters['page']);

					if ($_seoParameters['dofilter'] == 1)
					{
						// Also get rid of dofilter
						unset($_seoParameters['dofilter']);
					}
					
					// Don't get rid of everything
					$noClear = true;
				}
			}
			else if (!count($_seoParameters))
			{
				if ($newUrl = DBSEO::createUrl('SocialGroup_SocialGroupHome', $_seoParameters))
				{
					// Get rid of a few params
					unset($_seoParameters['do']);
					
					// Don't get rid of everything
					$noClear = true;
				}
			}
			else if ($_seoParameters['do'] == 'viewmembers')
			{
				$newUrl = DBSEO::createUrl('SocialGroup_SocialGroupMembers' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters);
			}
			else if ($_seoParameters['do'] == 'grouppictures')
			{
				$newUrl = DBSEO::createUrl('SocialGroup_SocialGroupPictures' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters);
			}
			else if ($_seoParameters['do'] == 'picture')
			{
				if (isset($_seoParameters['commentid']))
				{
					// Get the picture page
					$_seoParameters['page'] = DBSEO::getPicturePage($_seoParameters[DBSEO::$config['_pictureid']], $_seoParameters['commentid']);
					
					// Store URL place
					$_urlPlace = 'picturecomment_' . $_seoParameters['commentid'];
				}

				// Now finally grab the social group picture
				$newUrl = DBSEO::createUrl('SocialGroup_SocialGroupPicture' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters);
			}
			else if ($_seoParameters['groupid'] AND (!$_seoParameters['do'] OR $_seoParameters['do'] == 'view'))
			{
				// Just a social group
				$newUrl = DBSEO::createUrl('SocialGroup_SocialGroup' . ($_seoParameters['page'] > 1 ? '_Page' : ''), $_seoParameters);

				// Get rid of a few params
				unset($_seoParameters['do'], $_seoParameters['page'], $_seoParameters['groupid']);

				// Don't get rid of everything
				$noClear = true;
			}
		}

		if ($newUrl)
		{
			$_urlScript = $newUrl;
			if (!$noClear)
			{
				// We're not clearing
				$_removeAllParameters = true;
			}
		}
		else
		{
			// We didn't have a URL :(
			$_preventProcessing = true;
		}
		
		return $newUrl;
	}

	/**
	 * Create URL
	 *
	 * @param string $_seoParameters
	 * 
	 * @return string
	 */
	public static function createUrl($_seoParameters)
	{
		$newUrl = $_urlFormat = '';
		
		if (!DBSEO::$config['dbtech_dbseo_rewrite_socialgroup'])
		{
			// We're not rewriting this
			return false;
		}

		if ($_seoParameters['gmid'] AND !isset($_seoParameters['do']))
		{
			$_seoParameters['page'] = DBSEO::getGroupPage($_seoParameters['groupid'], $_seoParameters['gmid']);
		}

		if ($_seoParameters['pp'] == DBSEO::$config['vm_perpage'])
		{
			// We don't need perpage if it's default
			unset($_seoParameters['pp']);
		}

		if (isset($_seoParameters['page']) AND $_seoParameters['page'] < 2)
		{
			// We don't want to display page if it's 1
			unset($_seoParameters['page']);
		}

		if ($_seoParameters['gmid'] AND $_seoParameters['do'] == 'discuss')
		{
			// Set the page
			$_seoParameters['page'] = DBSEO::getGroupMessagePage($_seoParameters['discussionid'], $_seoParameters['gmid']);

			// Set the format
			$_newFormat = 'SocialGroup_SocialGroupDiscussion' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['do'] == 'grouplist' AND !$_seoParameters['cat'])
		{
			$_newFormat = 'SocialGroup_SocialGroupList' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['do'] == 'discuss' AND !$_seoParameters['gmid'])
		{
			$_newFormat = 'SocialGroup_SocialGroupDiscussion' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['do'] == 'categorylist')
		{
			$_newFormat = 'SocialGroup_SocialGroupCategoryList' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['cat'] AND (count($_seoParameters) == 1 OR $_seoParameters['page'] OR $_seoParameters['do'] == 'grouplist'))
		{
			$_urlFormat = 'SocialGroup_SocialGroupCategory' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if (!count($_seoParameters))
		{
			$_urlFormat = 'SocialGroup_SocialGroupHome';
		}
		else if ($_seoParameters['do'] == 'viewmembers')
		{
			$_urlFormat = 'SocialGroup_SocialGroupMembers' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['do'] == 'grouppictures')
		{
			$_urlFormat = 'SocialGroup_SocialGroupPictures' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['do'] == 'picture')
		{
			if (isset($_seoParameters['commentid']))
			{
				// Get the picture page
				$_seoParameters['page'] = DBSEO::getPicturePage($_seoParameters[DBSEO::$config['_pictureid']], $_seoParameters['commentid']);
			}

			// Now finally grab the social group picture
			$_urlFormat = 'SocialGroup_SocialGroupPicture' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if ($_seoParameters['groupid'] AND (!$_seoParameters['do'] OR $_seoParameters['do'] == 'view'))
		{
			// Just a social group
			$_urlFormat = 'SocialGroup_SocialGroup' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}

		if (!$_urlFormat)
		{
			// We're not rewriting this
			return $newUrl;
		}

		return DBSEO::createUrl($_urlFormat, $_seoParameters);
	}
}
?>